/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks;

import com.ordana.immersive_weathering.blocks.LayerBlock;
import com.ordana.immersive_weathering.blocks.ModBlockProperties;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.entities.FallingLayerEntity;
import com.ordana.immersive_weathering.reg.ModParticles;
import com.ordana.immersive_weathering.reg.ModTags;
import com.ordana.immersive_weathering.util.WeatheringHelper;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_4019;
import net.minecraft.class_4466;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class LeafPileBlock
extends LayerBlock
implements class_2256 {
    private static final int FIRE_SPREAD = 30;
    private static final int FLAMMABILITY = 60;
    public static final class_2758 LAYERS = ModBlockProperties.LEAF_LAYERS;
    private static final class_265[] SHAPE_BY_LAYER_L = new class_265[9];
    private static final float[] COLLISIONS;
    private final boolean canBeBonemealed;
    private final boolean hasThorns;
    private final List<Supplier<class_2400>> particles;
    private final LeavesType leafType;

    public LeafPileBlock(class_4970.class_2251 settings, LeavesType leafType) {
        super(settings);
        this.leafType = leafType;
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)LAYERS, (Comparable)Integer.valueOf(1)));
        String name = leafType.id.method_12832();
        this.canBeBonemealed = name.contains("flower");
        this.hasThorns = name.equals("spruce");
        this.particles = List.of(() -> ModParticles.FALLING_LEAVES_PARTICLES.get(leafType));
        RegHelper.registerBlockFlammability((class_2248)this, (int)30, (int)60);
    }

    public LeavesType getLeafType() {
        return this.leafType;
    }

    @PlatformOnly(value={"fabric"})
    public int getFlammability(class_2680 state, class_1922 level, class_2338 pos, class_2350 direction) {
        return 60;
    }

    @Override
    public int getLayers(class_2680 state) {
        return (Integer)state.method_11654((class_2769)LAYERS);
    }

    @Override
    public class_2758 layerProperty() {
        return LAYERS;
    }

    public int method_9505(class_2680 state, class_1922 world, class_2338 pos) {
        return 1;
    }

    @Override
    public class_265 getDefaultShape(class_2680 state) {
        return SHAPE_BY_LAYER_L[(Integer)state.method_11654((class_2769)LAYERS)];
    }

    public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        int layers = this.getLayers(state);
        if (layers > 3 && CommonConfigs.LEAF_PILES_SLOW.get().booleanValue() && entity instanceof class_1309 && !(entity instanceof class_4019) && !(entity instanceof class_4466) && class_1890.method_8203((class_1887)class_1893.field_9128, (class_1309)((class_1309)entity)) <= 0) {
            class_1657 player;
            float stuck = COLLISIONS[Math.max(0, layers - 1)];
            entity.method_5844(state, new class_243((double)stuck, 1.0, (double)stuck));
            if (!(layers < 6 || !this.hasThorns || level.field_9236 || entity.field_6038 == entity.method_23317() && entity.field_5989 == entity.method_23321() || entity instanceof class_1657 && !(player = (class_1657)entity).method_6118(class_1304.field_6172).method_7960())) {
                double d = Math.abs(entity.method_23317() - entity.field_6038);
                double e = Math.abs(entity.method_23321() - entity.field_5989);
                if (d >= (double)0.003f || e >= (double)0.003f) {
                    entity.method_5643(class_1282.field_16992, 0.5f * (float)(layers - 5));
                }
            }
        }
        if (layers > 0 && level.field_9236 && entity instanceof class_1309 && entity.method_36601().method_27852((class_2248)this)) {
            boolean bl;
            class_5819 random = level.method_8409();
            boolean bl2 = bl = entity.field_6038 != entity.method_23317() || entity.field_5989 != entity.method_23321();
            if (bl && random.method_43056()) {
                double y = (double)pos.method_10264() + SHAPE_BY_LAYER_L[layers].method_1105(class_2350.class_2351.field_11052) + 0.0625;
                int color = class_310.method_1551().method_1505().method_1697(state, (class_1920)level, pos, 0);
                for (Supplier<class_2400> p : this.particles) {
                    level.method_8406((class_2394)p.get(), entity.method_23317() + (double)class_3532.method_32750((class_5819)random, (float)-0.2f, (float)0.2f), y, entity.method_23321() + (double)class_3532.method_32750((class_5819)random, (float)-0.2f, (float)0.2f), (double)class_3532.method_32750((class_5819)random, (float)-0.75f, (float)-1.0f), (double)color, 0.0);
                }
            }
        }
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_3727 c;
        class_1297 e;
        if (context instanceof class_3727 && (e = (c = (class_3727)context).method_32480()) instanceof FallingLayerEntity) {
            return SHAPE_BY_LAYER_L[(Integer)state.method_11654((class_2769)LAYERS)];
        }
        return class_259.method_1073();
    }

    @Override
    public class_265 method_26159(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return SHAPE_BY_LAYER_L[this.getLayers(state)];
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2680 bottomState = world.method_8320(pos.method_10074());
        if (bottomState.method_26204() instanceof class_2397) {
            return true;
        }
        if ((Integer)state.method_11654((class_2769)LAYERS) != 0 && !bottomState.method_26206((class_1922)world, pos.method_10074(), class_2350.field_11036)) {
            return false;
        }
        return !this.shouldFall(state, world.method_8320(pos.method_10074()));
    }

    @Override
    public boolean shouldFall(class_2680 state, class_2680 belowState) {
        if ((Integer)state.method_11654((class_2769)LAYERS) == 0 && belowState.method_27852(class_2246.field_10382) || belowState.method_26164(ModTags.LEAF_PILES)) {
            return false;
        }
        return super.shouldFall(state, belowState);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction == class_2350.field_11033 && (Integer)state.method_11654((class_2769)LAYERS) <= 1) {
            state = (class_2680)state.method_11657((class_2769)LAYERS, (Comparable)Integer.valueOf(neighborState.method_27852(class_2246.field_10382) ? 0 : 1));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public boolean method_9616(class_2680 state, class_1750 context) {
        int i = (Integer)state.method_11654((class_2769)LAYERS);
        if (context.method_8041().method_31574(this.method_8389()) && i < 8 && i > 0) {
            return true;
        }
        return i < 3;
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 blockState = ctx.method_8045().method_8320(ctx.method_8037());
        if (blockState.method_27852((class_2248)this)) {
            int i = (Integer)blockState.method_11654((class_2769)LAYERS);
            return (class_2680)blockState.method_11657((class_2769)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        if (blockState.method_26227().method_39360((class_3611)class_3612.field_15910)) {
            return null;
        }
        class_2680 below = ctx.method_8045().method_8320(ctx.method_8037().method_10074());
        if (below.method_26227().method_39360((class_3611)class_3612.field_15910)) {
            if (!blockState.method_26215()) {
                return null;
            }
            return (class_2680)this.method_9564().method_11657((class_2769)LAYERS, (Comparable)Integer.valueOf(0));
        }
        return super.method_9605(ctx);
    }

    public boolean method_9651(class_1922 world, class_2338 pos, class_2680 state, boolean isClient) {
        return this.canBeBonemealed;
    }

    public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return this.canBeBonemealed;
    }

    public void method_9652(class_3218 world, class_5819 random, class_2338 pos, class_2680 state) {
        for (class_2350 direction : class_2350.values()) {
            if (!(random.method_43057() > 0.5f)) continue;
            class_2338 targetPos = pos.method_10093(direction);
            class_2680 targetBlock = world.method_8320(targetPos);
            WeatheringHelper.getAzaleaGrowth(targetBlock).ifPresent(s -> world.method_8501(targetPos, s));
        }
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        class_2338 blockPos;
        if (random.method_43048(16) == 0 && LeafPileBlock.method_10128((class_2680)level.method_8320(blockPos = pos.method_10074()))) {
            class_2400 leafParticle = WeatheringHelper.getFallenLeafParticle(state).orElse(null);
            if (leafParticle == null) {
                return;
            }
            int color = class_310.method_1551().method_1505().method_1697(state, (class_1920)level, pos, 0);
            for (Supplier<class_2400> p : this.particles) {
                if (!((double)random.method_43057() < 0.2)) continue;
                double d = (double)pos.method_10263() + random.method_43058();
                double e = (double)pos.method_10264() - 0.05;
                double f = (double)pos.method_10260() + random.method_43058();
                level.method_8406((class_2394)leafParticle, d, e, f, 0.0, (double)color, 0.0);
            }
        }
    }

    static {
        Arrays.setAll(SHAPE_BY_LAYER_L, l -> class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(l * 2), (double)16.0));
        LeafPileBlock.SHAPE_BY_LAYER_L[0] = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        COLLISIONS = new float[]{1.0f, 0.999f, 0.998f, 0.997f, 0.996f, 0.994f, 0.993f, 0.992f};
    }
}

